package ch.sahits.game.openpatrician.model.people;

import ch.sahits.game.openpatrician.model.ship.IShip;

import java.util.Optional;

/**
 * Interface describing a captain
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 19, 2013
 *
 */
public interface ICaptain extends IPerson{
	/**
	 * Current age of the captain
	 * @return
	 */
	int getAge();
	/**
	 * Retrieve the name of the captain
	 * @return
	 */
	String getName();
	/**
	 * Retrieve the salary per day.
	 * @return
	 */
	int getSalary();
	/**
	 * Retrieve the level in trading between [0,5]
	 * @return
	 */
	int getTradingSkillLevel();
	/**
	 * Add the profit the total profit.
	 * @param profit additional profit
	 */
	void updateProfit(int profit);

	/**
	 * Add the sailed distance to the total
	 * @param distance additional distance
	 */
	void updatedSailedDistance(int distance);

	/**
	 * If possible upgrade the captain to the next level on navigation skill.
	 * @return true if upgrade happened
 	 */
	boolean upgradeToNextNavigationLevel();

	/**
	 * Increase the number of won fights.
	 */
	void updateFightWon();

	/**
	 * If possible upgrade the captain fight skill to the next level.
	 * @return true if an upgrade happened
	 */
	boolean upgradeToNextFightingLevel();
	/**
	 * Increase the experiance level by one. The highest level i 5.
	 * @return true if upgrade happened.
	 */
	boolean upgradeToNextTradeLevel();
	/**
	 * Retrieve the level in navigation between [0,5]
	 * @return
	 */
	int getNavigationSkillLevel();
	/**
	 * Retrieve the level in sea fights between [0,5]
	 * @return
	 */
	int getFightSkillLevel();
	/**
	 * Get the ship the captain is assigned to.
	 * @return absent if the captain is not assigned to any ship.
	 */
	Optional<IShip> getAssignedShip();

	/**
	 * Assign a captain to a ship.
	 * @param ship to which the captain is assigned.
     */
	void assignToShip(IShip ship);
}
