package ch.sahits.game.openpatrician.model.people;

import ch.sahits.game.openpatrician.model.city.ICity;


/**
 * Defining a trader with missing ships capacities, who has
 * to get to another city with his wares.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 27, 2013
 *
 */
public interface ITransportTrader extends ISideRoomPerson {
	/**
	 * Retrieve the name of the trader.
	 * @return
	 */
	String getName();
	/**
	 * Destination city the trader has to get to.
	 * @return
	 */
	ICity getDestination();
	/**
	 * Retrieve the needed capacity in bales for the transport.
	 * @return
	 */
	int getNeededCapacity();
	/**
	 * Retrieve the premium.
	 * @return
	 */
	int getPremium();

	void setName(String name);

	void setDestination(ICity destination);

	void setPremium(int premium);

	 void setNeededCapacity(int neededCapacity);
}
