package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.people.ICaptain;

import java.time.Duration;
import java.time.LocalDateTime;

/**
 * Utility class to track which captain got when in which town
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 19, 2013
 *
 */
@RequiredArgsConstructor
@ClassCategory(EClassCategory.DEPENDS_ON_SERIALIZED_BEAN)
public class CaptainTownMapping {
    @Getter
	private final ICity town;
    @Getter
	private final LocalDateTime arrivalDate;
    @Getter
	private final ICaptain captain;

	public int getNumbersOfDaysInTown(Date currentDate) {
		LocalDateTime now = currentDate.getCurrentDate();
		Duration duration = Duration.between(arrivalDate, now);
		return (int) duration.toDays();
	}
}
