package ch.sahits.game.openpatrician.model.people.impl;


import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.model.people.ISeaPirate;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import lombok.Getter;
import lombok.Setter;

/**
 * Implementation of the sea pirate
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 29, 2013
 *
 */
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@Prototype
public class SeaPirate implements ISeaPirate {
    @Getter
    @Setter
	private String name;
	@Getter
	@Setter
	private String lastName;
    @Getter
    @Setter
	private INavigableVessel ship;
    @Getter
	private int numberOfKills;
	public void incNumberOfKills() {
        numberOfKills++;
	}

}
