package ch.sahits.game.openpatrician.model.player;

import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.IShip;

import java.util.Optional;

/**
 * Strategy to determine when and how to purchase ship weapons.
 * @author Andi Hotz, (c) Sahits GmbH, 2017
 * Created on Oct 18, 2017
 */
public interface IAIBuyWeaponStrategy {
    /**
     * Determine if weapons should be bougth and if so to meet which target.
     * @param ship for which the weapons should be bought
     * @param player who is purchasing the weapons
     * @param city in which to buy weapons
     * @return optional of {@link BuyWeapons} defining the target that should be reached. If the optional is not filled
     * This means, no weapons should be bought.
     */
    Optional<BuyWeapons> shouldBuyWeapons(IShip ship, IAIPlayer player, ICity city);

    /**
     * Buy the weapons. Some of the target may contradict each other. It is in the scope of the implementation which
     * target has more weight.
     * @param target defining the target that should be met by buying the weapons.
     * @param ship for which the weapons should be bought
     * @param player who is purchasing the weapons
     * @param city in which to buy weapons
     */
    void buyWeapons(BuyWeapons target, IShip ship, IAIPlayer player, ICity city);
}
