package ch.sahits.game.openpatrician.model.player;

import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;

/**
 * Stragegy to handle the hiring and dimissal policies for a trade manager.
 * @author Andi Hotz, (c) Sahits GmbH, 2017
 * Created on Oct 17, 2017
 */
public interface IAIHireTradeManagerStrategy {

    /**
     * Decide if a trade manager should be hired or dismissed.
     * @param city for which it should be ckecked
     * @param player for which the checking happens
     * @return true if the trade manager should be hired or dismissed.
     */
    boolean hireOrFireTradeManager(ICity city, IAIPlayer player);

    /**
     * Hire or dismiss a trading manager.
     * @param city in which the hiring is done
     * @param player for which the hiring is done.
     */
    void hireOrDismiss(ICity city, IAIPlayer player);
}
