package ch.sahits.game.openpatrician.model.sea;

import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.IShip;

import java.time.LocalDateTime;
import java.util.List;

/**
 * State of a single blockade.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Apr 14, 2016
 */
public interface IBlockade {
    /**
     * Date when the convoy is assembled to travel to the city to be blockaded.
     * @return
     */
    LocalDateTime getAssemblyDate();

    /**
     * End date of the blockade.
     * @return
     */
    LocalDateTime getEndBlockade();

    /**
     * Retrieve the blockade convoy
     * @return
     */
    IConvoy getBlockadeConvoy();

    /**
     * Retrieve the ships of a certain player.
     * @param player
     * @return
     */
    List<IShip> getShips(IPlayer player);
    /**
     * Retrieve all ships for the blockade.
     * @return
     */
    List<IShip> getShips();

    /**
     * Retrieve a list of players which have requested a ship
     * @return
     */
    List<IPlayer> getPlayersWithRequestedShips();

    /**
     * Retrieve the number of ships that are requested.
     * @param player
     * @return
     */
    int getNumberOfRequestedShips(IPlayer player);

    /**
     * Add a number of ships for a player to the blockade.
     * @param player
     * @param shipList
     */
    void addShips(IPlayer player, List<IShip> shipList);

    /**
     * Set the convoy.
     * @param convoy
     */
    void setConvoy(IConvoy convoy);

    /**
     * List containing ships that were captured during the blockade mission,
     * that will be auctioned at the end.
     * @return
     */
    List<IShip> getShipsToAuction();


}
