package ch.sahits.game.openpatrician.model.server;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import ch.sahits.game.openpatrician.utilities.annotation.MapType;
import ch.sahits.game.openpatrician.model.map.MapSegmentedImage;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import lombok.Getter;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Dec 07, 2015
 */
@ClassCategory({EClassCategory.SINGLETON_BEAN, EClassCategory.SERIALIZABLE_BEAN})
@Component
@Lazy
public class MapLocationDetectionModel {
    @ListType(MapSegmentedImage.class)
    @Getter
    private List<MapSegmentedImage> mapSegments = new ArrayList<>();

    @MapType(key=INavigableVessel.class, value = MapSegmentDataCheck.class)
    @Getter
    private Map<INavigableVessel,MapSegmentDataCheck> checkList = new HashMap<>();

    public void addSegment(MapSegmentedImage map) {
        mapSegments.add(map);
    }
    public void removeSegment(MapSegmentedImage map) {mapSegments.remove(map);}
    public boolean containsSegment(MapSegmentedImage map) {return mapSegments.contains(map);}

    public boolean isInCheckedList(INavigableVessel ship) {
        return checkList.containsKey(ship);
    }

}
