package ch.sahits.game.openpatrician.model.ship;

import java.util.List;

/**
 * A Ship group is similar to a {@link IConvoy} only that there is no Orleg ship.
 * This type of ships is usually found with pirates, when the capture more ships.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Dec 08, 2015
 */
public interface IShipGroup extends IGroupableVessel {
    /**
     * Retrieve a list of the ships in the convoy.
     * @return
     */
    List<IShip> getShips();
    /**
     * Add a ship to the convoy.
     * @param ship to be added.
     */
    void addShip(IShip ship);

    /**
     * Remove a ship from the convoy.
     * @param ship to be removed.
     */
    void removeShip(IShip ship);
}
