package ch.sahits.game.openpatrician.model.ship.impl;

import ch.sahits.game.openpatrician.model.ship.ShipProperties;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.model.ship.ISnaikka;
import ch.sahits.game.openpatrician.model.ship.EShipType;
import ch.sahits.game.openpatrician.model.ship.EShipUpgrade;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.PostConstruct;

@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class Snaikka extends Ship implements ISnaikka {
	@Autowired
	@XStreamOmitField
	private ShipProperties shipProperties;
	@Autowired
	@XStreamOmitField
	private ShipWeaponsLocationFactory weaponsLocationFactory;
	/**
	 * Constructor initializing the name and the upgrade level
	 * @param upgradeLevel
	 * @param name ships name
	 */
	public Snaikka(EShipUpgrade upgradeLevel, String name) {
		this.shipUpgradeLevel = upgradeLevel;
		this.name = name;
	}
	/**
	 * Constructor for a Crayer without any upgrade
	 * @param name ships name
	 */
	public Snaikka(String name) {
		this(EShipUpgrade.NONE,name);
	}

	@PostConstruct
	private void init() {
		super.initializeProperties(shipProperties.getSnaikka());
		setWeaponSlots(weaponsLocationFactory.getShipWeaponsLocation(EShipType.SNAIKKA, shipUpgradeLevel));
	}

	@Override
	public EShipType getShipType() {
		return EShipType.SNAIKKA;
	}

}
