package ch.sahits.game.openpatrician.model.ui;

/**
 * Dialogs that are not called from a UI state must carry their own state from
 * the time when they were created. Typical examples are dialogs that are displayed
 * due to a message.<br>
 * A dialog state may also carry data that is not used for a dialog. In such cases
 * it is a convenient vessel to transport data to display in a dialog if the recipient
 * is a human player or to trigger some action in the background.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Dec 06, 2016
 */
public interface IDialogState {
    /**
     * Retrieve the bean name of the dialog.
     * @return
     */
    String getDialogBeanName();
}
