package ch.sahits.game.openpatrician.model.weapon;

import ch.sahits.game.openpatrician.model.IAmountable;
import ch.sahits.game.openpatrician.model.product.ITradable;

/**
 * This interface defines a weapon.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Dec 23, 2011
 *
 */
public interface IWeapon extends IAmountable, ITradable {
    /**
     * Get the required storing space for this weapon.
     * @return
     */
    double getSize();

    /**
     * Get the strength of the weapon.
      * @return
     */
    double getStrength();

    /**
     * Get the inflicted damage on a structure in case of a hit.
     * @return
     */
    double getDamage();

    /**
     * Get the kill damage in case of a hit.
      * @return
     */
    double getKill();

    /**
     * Get the weapons range
     * @return
     */
    int getRange();
}
