/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.city.cityhall.impl;

import ch.sahits.game.openpatrician.model.DateService;
import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.cityhall.AldermanCandidateList;
import ch.sahits.game.openpatrician.model.city.cityhall.IAldermanOffice;
import ch.sahits.game.openpatrician.model.city.cityhall.IBallot;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityGuard;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityHall;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityHallNotice;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityPetition;
import ch.sahits.game.openpatrician.model.city.cityhall.IElectionResult;
import ch.sahits.game.openpatrician.model.city.cityhall.IOutriggerContract;
import ch.sahits.game.openpatrician.model.city.cityhall.ITreasury;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import ch.sahits.game.openpatrician.utilities.annotation.OptionalType;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.beans.ConstructorProperties;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import javafx.collections.ObservableList;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class CityHall
implements ICityHall {
    @ListType(value=ICityHallNotice.class)
    private final ObservableList<ICityHallNotice> notices;
    @OptionalType(value=IOutriggerContract.class)
    private Optional<IOutriggerContract> outriggerContract = Optional.empty();
    private ICitizen mayor;
    private LocalDateTime electionDate;
    @ListType(value=ICitizen.class)
    private final List<ICitizen> candidates;
    @OptionalType(value=LocalDateTime.class)
    private Optional<LocalDateTime> nextCouncilMeeting = Optional.empty();
    @OptionalType(value=ICityPetition.class)
    private Optional<ICityPetition> petition = Optional.empty();
    private ICitizen alderman;
    private LocalDateTime aldermanElectionDate;
    @Autowired
    private AldermanCandidateList aldermanCandidates;
    private final ITreasury treasury;
    @ListType(value=ICityGuard.class)
    private final List<ICityGuard> cityGuard;
    @OptionalType(value=IAldermanOffice.class)
    private Optional<IAldermanOffice> aldermanOffice = Optional.empty();
    private final ICity city;
    @ListType(value=ICitizen.class)
    private final List<ICitizen> councilmen;
    @OptionalType(value=LocalDateTime.class)
    private Optional<LocalDateTime> hanseaticMeetingDate = Optional.empty();
    @OptionalType(value=IElectionResult.class)
    private Optional<IElectionResult> electionResult = Optional.empty();
    @OptionalType(value=IBallot.class)
    private Optional<IBallot> ballotResult = Optional.empty();
    private int maxNumberMilita;
    @Autowired
    @XStreamOmitField
    private DateService date;

    public void setAldermanElectionDate(LocalDateTime aldermanElectionDate) {
        LocalDateTime proposedDate = aldermanElectionDate;
        while (!this.isAldermanElectionDateOk(proposedDate)) {
            proposedDate = proposedDate.plusDays(1L);
        }
        this.aldermanElectionDate = proposedDate;
    }

    public void setElectionDate(LocalDateTime electionDate) {
        LocalDateTime proposedDate = electionDate;
        while (!this.isMayoralElectionDateOk(proposedDate)) {
            proposedDate = proposedDate.plusDays(1L);
        }
        this.electionDate = proposedDate;
    }

    public void setNextCouncilMeeting(Optional<LocalDateTime> nextCouncilMeeting) {
        if (nextCouncilMeeting.isPresent()) {
            LocalDateTime proposedDate = nextCouncilMeeting.get();
            while (!this.isCouncilMeetingDateOk(proposedDate)) {
                proposedDate = proposedDate.plusDays(1L);
            }
            this.nextCouncilMeeting = Optional.of(proposedDate);
        } else {
            this.nextCouncilMeeting = nextCouncilMeeting;
        }
    }

    public void setHanseaticMeetingDate(Optional<LocalDateTime> meetingDate) {
        if (meetingDate.isPresent()) {
            LocalDateTime proposedDate = meetingDate.get();
            while (!this.isHanseaticMeetingDateOk(proposedDate)) {
                proposedDate = proposedDate.plusDays(1L);
            }
            this.hanseaticMeetingDate = Optional.of(proposedDate);
        } else {
            this.hanseaticMeetingDate = meetingDate;
        }
    }

    private boolean isAldermanElectionDateOk(LocalDateTime electionDate) {
        if (this.electionDate != null && this.date.isSameDay(electionDate, this.electionDate)) {
            return false;
        }
        if (this.nextCouncilMeeting.isPresent() && this.date.isSameDay(electionDate, this.nextCouncilMeeting.get())) {
            return false;
        }
        return !this.hanseaticMeetingDate.isPresent() || !this.date.isSameDay(electionDate, this.hanseaticMeetingDate.get());
    }

    private boolean isMayoralElectionDateOk(LocalDateTime electionDate) {
        if (this.aldermanElectionDate != null && this.date.isSameDay(electionDate, this.aldermanElectionDate)) {
            return false;
        }
        if (this.nextCouncilMeeting.isPresent() && this.date.isSameDay(electionDate, this.nextCouncilMeeting.get())) {
            return false;
        }
        return !this.hanseaticMeetingDate.isPresent() || !this.date.isSameDay(electionDate, this.hanseaticMeetingDate.get());
    }

    private boolean isCouncilMeetingDateOk(LocalDateTime meetingDate) {
        if (this.electionDate != null && this.date.isSameDay(meetingDate, this.electionDate)) {
            return false;
        }
        if (this.aldermanElectionDate != null && this.date.isSameDay(meetingDate, this.aldermanElectionDate)) {
            return false;
        }
        return !this.hanseaticMeetingDate.isPresent() || !this.date.isSameDay(meetingDate, this.hanseaticMeetingDate.get());
    }

    private boolean isHanseaticMeetingDateOk(LocalDateTime meetingDate) {
        if (this.electionDate != null && this.date.isSameDay(meetingDate, this.electionDate)) {
            return false;
        }
        if (this.aldermanElectionDate != null && this.date.isSameDay(meetingDate, this.aldermanElectionDate)) {
            return false;
        }
        return !this.nextCouncilMeeting.isPresent() || !this.date.isSameDay(meetingDate, this.nextCouncilMeeting.get());
    }

    @ConstructorProperties(value={"notices", "candidates", "treasury", "cityGuard", "city", "councilmen"})
    public CityHall(ObservableList<ICityHallNotice> notices, List<ICitizen> candidates, ITreasury treasury, List<ICityGuard> cityGuard, ICity city, List<ICitizen> councilmen) {
        this.notices = notices;
        this.candidates = candidates;
        this.treasury = treasury;
        this.cityGuard = cityGuard;
        this.city = city;
        this.councilmen = councilmen;
    }

    @Override
    public ObservableList<ICityHallNotice> getNotices() {
        return this.notices;
    }

    @Override
    public Optional<IOutriggerContract> getOutriggerContract() {
        return this.outriggerContract;
    }

    @Override
    public void setOutriggerContract(Optional<IOutriggerContract> outriggerContract) {
        this.outriggerContract = outriggerContract;
    }

    @Override
    public ICitizen getMayor() {
        return this.mayor;
    }

    public void setMayor(ICitizen mayor) {
        this.mayor = mayor;
    }

    @Override
    public LocalDateTime getElectionDate() {
        return this.electionDate;
    }

    @Override
    public List<ICitizen> getCandidates() {
        return this.candidates;
    }

    @Override
    public Optional<LocalDateTime> getNextCouncilMeeting() {
        return this.nextCouncilMeeting;
    }

    @Override
    public Optional<ICityPetition> getPetition() {
        return this.petition;
    }

    @Override
    public void setPetition(Optional<ICityPetition> petition) {
        this.petition = petition;
    }

    @Override
    public ICitizen getAlderman() {
        return this.alderman;
    }

    public void setAlderman(ICitizen alderman) {
        this.alderman = alderman;
    }

    @Override
    public LocalDateTime getAldermanElectionDate() {
        return this.aldermanElectionDate;
    }

    @Override
    public AldermanCandidateList getAldermanCandidates() {
        return this.aldermanCandidates;
    }

    @Override
    public ITreasury getTreasury() {
        return this.treasury;
    }

    @Override
    public List<ICityGuard> getCityGuard() {
        return this.cityGuard;
    }

    @Override
    public Optional<IAldermanOffice> getAldermanOffice() {
        return this.aldermanOffice;
    }

    public void setAldermanOffice(Optional<IAldermanOffice> aldermanOffice) {
        this.aldermanOffice = aldermanOffice;
    }

    @Override
    public ICity getCity() {
        return this.city;
    }

    @Override
    public List<ICitizen> getCouncilmen() {
        return this.councilmen;
    }

    @Override
    public Optional<LocalDateTime> getHanseaticMeetingDate() {
        return this.hanseaticMeetingDate;
    }

    @Override
    public Optional<IElectionResult> getElectionResult() {
        return this.electionResult;
    }

    public void setElectionResult(Optional<IElectionResult> electionResult) {
        this.electionResult = electionResult;
    }

    @Override
    public Optional<IBallot> getBallotResult() {
        return this.ballotResult;
    }

    public void setBallotResult(Optional<IBallot> ballotResult) {
        this.ballotResult = ballotResult;
    }

    @Override
    public int getMaxNumberMilita() {
        return this.maxNumberMilita;
    }

    public void setMaxNumberMilita(int maxNumberMilita) {
        this.maxNumberMilita = maxNumberMilita;
    }
}

