/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.map;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.SetType;
import java.util.TreeSet;
import javafx.geometry.Point2D;

@ClassCategory(value={EClassCategory.MODEL, EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
public class MapSegmentedImage {
    private final String imageName;
    @SetType(value=Integer.class)
    private final TreeSet<Integer> segmentIndices;
    private final Point2D location;

    public MapSegmentedImage(String imageName, Point2D location) {
        this.imageName = imageName;
        this.location = location;
        this.segmentIndices = new TreeSet();
    }

    public void addSegment(int index) {
        this.segmentIndices.add(index);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MapSegmentedImage)) {
            return false;
        }
        MapSegmentedImage that = (MapSegmentedImage)o;
        if (this.getImageName() != null ? !this.getImageName().equals(that.getImageName()) : that.getImageName() != null) {
            return false;
        }
        return this.getLocation() != null ? this.getLocation().equals((Object)that.getLocation()) : that.getLocation() == null;
    }

    public int hashCode() {
        int result = this.getImageName() != null ? this.getImageName().hashCode() : 0;
        result = 31 * result + (this.getLocation() != null ? this.getLocation().hashCode() : 0);
        return result;
    }

    public String getImageName() {
        return this.imageName;
    }

    public TreeSet<Integer> getSegmentIndices() {
        return this.segmentIndices;
    }

    public Point2D getLocation() {
        return this.location;
    }
}

