/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.DateService;
import ch.sahits.game.openpatrician.model.people.ICaptain;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.MapType;
import ch.sahits.game.openpatrician.utilities.annotation.OptionalType;
import ch.sahits.game.openpatrician.utilities.service.RandomNameLoader;
import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class CaptainState
implements ICaptain {
    @Autowired
    private Date date;
    @Autowired
    @XStreamOmitField
    private DateService dateService;
    @Autowired
    @XStreamOmitField
    private Random rnd;
    private LocalDateTime birthDate;
    private String name;
    private int salary;
    private int tradingSkill;
    private int navigationSkill;
    private int fightingSkill;
    private int totalProfit;
    private long sailedDistance;
    private int wonFights;
    @OptionalType(value=IShip.class)
    private Optional<IShip> ship;
    private static final Range<Integer> skillRange = Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(5));
    @MapType(key=Integer.class, value=Integer.class)
    private static final Map<Integer, Integer> UPGRADE_NAVIGATION_LIMIT_LEVEL = new HashMap<Integer, Integer>();
    @MapType(key=Integer.class, value=Integer.class)
    private static final Map<Integer, Integer> UPGRADE_FIGHT_LIMIT_LEVEL = new HashMap<Integer, Integer>();
    @MapType(key=Integer.class, value=Integer.class)
    private static final Map<Integer, Integer> UPGRADE_TRADE_LIMIT_LEVEL = new HashMap<Integer, Integer>();
    private static RandomNameLoader firstNameLoader = new RandomNameLoader("captain-firstnames.properties");
    private static RandomNameLoader lastNameLoader = new RandomNameLoader("captain-lastnames.properties");

    public CaptainState() {
        UPGRADE_TRADE_LIMIT_LEVEL.put(0, 10000);
        UPGRADE_TRADE_LIMIT_LEVEL.put(1, 20000);
        UPGRADE_TRADE_LIMIT_LEVEL.put(2, 40000);
        UPGRADE_TRADE_LIMIT_LEVEL.put(3, 70000);
        UPGRADE_TRADE_LIMIT_LEVEL.put(4, 100000);
        UPGRADE_NAVIGATION_LIMIT_LEVEL.put(0, 10000);
        UPGRADE_NAVIGATION_LIMIT_LEVEL.put(1, 20000);
        UPGRADE_NAVIGATION_LIMIT_LEVEL.put(2, 40000);
        UPGRADE_NAVIGATION_LIMIT_LEVEL.put(3, 70000);
        UPGRADE_NAVIGATION_LIMIT_LEVEL.put(4, 100000);
        UPGRADE_FIGHT_LIMIT_LEVEL.put(0, 5);
        UPGRADE_FIGHT_LIMIT_LEVEL.put(1, 10);
        UPGRADE_FIGHT_LIMIT_LEVEL.put(2, 15);
        UPGRADE_FIGHT_LIMIT_LEVEL.put(3, 25);
        UPGRADE_FIGHT_LIMIT_LEVEL.put(4, 40);
    }

    @PostConstruct
    private void init() {
        this.name = firstNameLoader.getRandomName() + " " + lastNameLoader.getRandomName();
        this.birthDate = this.date.getCurrentDate().minusYears(this.rnd.nextInt(15) + 25).minusMonths(this.rnd.nextInt(12)).minusDays(this.rnd.nextInt(30));
        this.setFightSkillLevel(this.rnd.nextInt(6));
        this.setTradingSkillLevel(this.rnd.nextInt(6));
        this.setNavigationSkillLevel(this.rnd.nextInt(6));
        int age = this.getAge();
        int experianceLevel = (int)Math.min(5.0, (double)this.rnd.nextInt(6) * ((double)age / 50.0));
        this.setSalary(experianceLevel + 10 + this.tradingSkill * 2 + this.navigationSkill * 2 + this.fightingSkill * 2);
        this.ship = Optional.empty();
        this.totalProfit = 0;
    }

    @Override
    public int getAge() {
        return this.dateService.getAge(this.birthDate);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getSalary() {
        return this.salary;
    }

    @Override
    public int getTradingSkillLevel() {
        return this.tradingSkill;
    }

    @Override
    public int getNavigationSkillLevel() {
        return this.navigationSkill;
    }

    @Override
    public int getFightSkillLevel() {
        return this.fightingSkill;
    }

    private void setTradingSkillLevel(int level) {
        Preconditions.checkArgument((boolean)skillRange.contains((Comparable)Integer.valueOf(level)), (Object)"Level must be within [0,5]");
        this.tradingSkill = level;
    }

    private void setNavigationSkillLevel(int level) {
        Preconditions.checkArgument((boolean)skillRange.contains((Comparable)Integer.valueOf(level)), (Object)"Level must be within [0,5]");
        this.navigationSkill = level;
    }

    private void setFightSkillLevel(int level) {
        Preconditions.checkArgument((boolean)skillRange.contains((Comparable)Integer.valueOf(level)), (Object)"Level must be within [0,5]");
        this.fightingSkill = level;
    }

    public void setSalary(int salary) {
        this.salary = salary;
    }

    @Override
    public void assignToShip(IShip ship) {
        ship.setCaptain(this);
    }

    @Override
    public Optional<IShip> getAssignedShip() {
        return this.ship;
    }

    @Override
    public boolean upgradeToNextTradeLevel() {
        if (this.tradingSkill < 5 && this.totalProfit > UPGRADE_TRADE_LIMIT_LEVEL.get(this.navigationSkill)) {
            ++this.tradingSkill;
            this.salary = (int)(1.8 * (double)this.salary);
            return true;
        }
        return false;
    }

    @Override
    public void updateProfit(int profit) {
        this.totalProfit += profit;
    }

    @Override
    public void updatedSailedDistance(int distance) {
        this.sailedDistance += (long)distance;
    }

    @Override
    public boolean upgradeToNextNavigationLevel() {
        if (this.navigationSkill < 5 && this.sailedDistance > (long)UPGRADE_NAVIGATION_LIMIT_LEVEL.get(this.navigationSkill).intValue()) {
            ++this.navigationSkill;
            this.salary = (int)(1.8 * (double)this.salary);
            return true;
        }
        return false;
    }

    @Override
    public void updateFightWon() {
        ++this.wonFights;
    }

    @Override
    public boolean upgradeToNextFightingLevel() {
        if (this.fightingSkill < 5 && this.wonFights > UPGRADE_FIGHT_LIMIT_LEVEL.get(this.fightingSkill)) {
            ++this.fightingSkill;
            this.salary = (int)(1.8 * (double)this.salary);
            return true;
        }
        return false;
    }
}

