/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.sea;

import ch.sahits.game.openpatrician.model.sea.ITravellingVessels;
import ch.sahits.game.openpatrician.model.sea.TravellingVessel;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.MapType;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javafx.geometry.Point2D;
import javafx.scene.shape.Path;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.SINGLETON_BEAN})
@Component
@Lazy
public class TravellingVessels
implements ITravellingVessels {
    @MapType(key=INavigableVessel.class, value=TravellingVessel.class)
    private final Map<INavigableVessel, TravellingVessel> vessels = new ConcurrentHashMap<INavigableVessel, TravellingVessel>();

    public void addVessel(INavigableVessel vessel, Optional<Path> path, List<Point2D> points) {
        TravellingVessel tv = new TravellingVessel(vessel);
        tv.setCalculatablePath(points);
        if (path.isPresent()) {
            tv.setDrwawablePath(path.get());
        }
        this.vessels.put(vessel, tv);
    }

    public void remove(INavigableVessel vessel) {
        this.vessels.remove(vessel);
    }

    @Override
    public Iterator<INavigableVessel> iterator() {
        return this.vessels.keySet().iterator();
    }

    @Override
    public TravellingVessel getTravellingVessel(INavigableVessel vessel) {
        return this.vessels.get(vessel);
    }

    @Override
    public boolean isTravelling(INavigableVessel vessel) {
        return this.vessels.containsKey(vessel);
    }
}

