/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.server;

import ch.sahits.game.openpatrician.data.xmlmodel.City;
import ch.sahits.game.openpatrician.data.xmlmodel.Location;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import ch.sahits.game.openpatrician.utilities.plugin.IMapPluginLoader;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ServiceLoader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;

@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
@LazySingleton
public class MapProviderService {
    private final Logger logger = LogManager.getLogger(this.getClass());
    @Autowired
    @Qualifier(value="jaxb2XmlModelMarshaller")
    private Jaxb2Marshaller mapMarshaller;

    public Map<String, String> getMaps() {
        LinkedHashMap<String, String> maps = new LinkedHashMap<String, String>();
        maps.put("ch.sahits.game.openpatrician.display.scene.NewGameScene.standard", "/standartHanseaticMap.xml");
        this.verifyMapDimenstions("/standartHanseaticMap.xml");
        ServiceLoader<IMapPluginLoader> mapLoaders = ServiceLoader.load(IMapPluginLoader.class, ClassLoader.getSystemClassLoader());
        for (IMapPluginLoader mapLoader : mapLoaders) {
            this.verifyMapDimenstions(mapLoader.getMapDefinition());
            maps.put(mapLoader.getMapTextKey(), mapLoader.getMapDefinition());
        }
        return maps;
    }

    private void verifyMapDimenstions(String mapDefinition) {
        ch.sahits.game.openpatrician.data.xmlmodel.Map map = (ch.sahits.game.openpatrician.data.xmlmodel.Map)this.mapMarshaller.unmarshal(this.getSourceFromFile(mapDefinition));
        int heigth = map.getDimension().getY();
        for (City city : map.getCities().getCity()) {
            Location location = city.getLocation();
            if (location.getX() < 30) {
                this.logger.warn("The city {} must be at least 30 pixels from the left edge", (Object)city.getName());
            }
            if (location.getY() < 40) {
                this.logger.warn("The city {} must be at least 40 pixels from the  top border", (Object)city.getName());
            }
            if (location.getY() <= heigth - 92) continue;
            this.logger.warn("The city {} must be at lease 92 pixels from the bottom border", (Object)city.getName());
        }
    }

    private Source getSourceFromFile(String fileName) {
        InputStream resourceAsStream = this.getClass().getResourceAsStream(fileName);
        return new StreamSource(resourceAsStream);
    }
}

