package ch.sahits.game.openpatrician.model;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import lombok.Getter;

/**
 * Message that can be displayed on screen. The message contents is formatted with markup.
 * A short message is displayed as a notification. The message will be displayed in the notice
 * board.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Feb 18, 2013
 *
 */
@ClassCategory(EClassCategory.DEPENDS_ON_SERIALIZED_BEAN)
public class DisplayMessage {
    @Getter
	private final String messageKey;
	@Getter
	private final Object[] messageArguments;


	public DisplayMessage(String messageKey, Object...messageArgs) {
		super();
		this.messageKey = messageKey;
		messageArguments = messageArgs;
	}
}
