package ch.sahits.game.openpatrician.model;

import ch.sahits.game.openpatrician.model.city.ICity;
import javafx.beans.property.LongProperty;


/**
 * The Company interface represents the company of a player and is mainly used to
 * gather statistics
 * @author Andi Hotz, (c) Sahits GmbH, 2012
 * Created on Jul 24, 2012
 *
 */
public interface ICompany {
	/**
	 * Retrieve the home town of the company
	 * @return
	 */
	ICity getHomeTown();
	/**
	 * Retrieve the total value of the company
	 * @return
	 */
	long getCompanyValue();

	/**
	 * Set a new company value.
	 * @param newValue
     */
	void setCompanyValue(long newValue);
	/**
	 * Retrieve the cash avalable to the company
	 * @return
	 */
	long getCash();

	/**
	 * Add or subtract some cash directly. This method is intended for calls
	 * that do not originate in the UI.
	 * @param diff
	 */
	void updateCashDirectly(long diff);
	/**
	 * Add or subtract some cash
	 * @param diff amount of money that is transferred
	 */
	void updateCash(long diff);
    /**
     * Retrieve the cash property.
     * @return property
     */
    LongProperty cashProperty();

}
