package ch.sahits.game.openpatrician.model.city.cityhall.impl;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.city.cityhall.IBallot;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityPetition;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityViolation;
import lombok.Getter;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Apr 06, 2015
 */
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class Ballot implements IBallot {
    @Getter
    private int numberYes = 0;
    @Getter
    private int numberNo = 0;
    @Getter
    private ICityPetition petition;
    @Getter
    private ICityViolation violation;

    public Ballot(ICityPetition petition) {
        this.petition = petition;
    }

    public Ballot(ICityViolation violation) {
        this.violation = violation;
    }

    @Override
    public void vote(boolean yes) {
        if (yes) {
            numberYes++;
        } else {
            numberNo++;
        }
    }
}
