package ch.sahits.game.openpatrician.model.city.cityhall.impl;

import ch.sahits.game.openpatrician.model.city.cityhall.ICityGuard;
import com.google.common.base.Preconditions;
import lombok.Getter;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 31, 2014
 */
public abstract class CityGuard implements ICityGuard {
    @Getter
    private int amount;


    @Override
    public void update(int amount) {
        Preconditions.checkArgument(this.amount + amount > 0, "Total amount may not become negative");
         this.amount += amount;
    }
}
