package ch.sahits.game.openpatrician.model.city.guild;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import ch.sahits.game.openpatrician.utilities.spring.DependentPropertyInitializer;
import ch.sahits.game.openpatrician.utilities.spring.DependentValue;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import lombok.Getter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.PostConstruct;

/**
 * This settings class holds all the common setting for all guilds, so that this object can be a singleton,
 * while the guilds themselves are prototypes.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Nov 06, 2016
 */
@LazySingleton
@ClassCategory({EClassCategory.SINGLETON_BEAN, EClassCategory.SERIALIZABLE_BEAN})
public class GuildSettings {
    @XStreamOmitField
    private static final Logger LOGGER = LogManager.getLogger(GuildSettings.class);
    @DependentValue("guild.entry.fee.min")
    @Getter
    private int minEntryFee = 15000;
    @DependentValue("guild.entry.fee.max")
    @Getter
    private int maxEntryFee = 65000;
    @Autowired
    @Getter
    private IMediterreanMap mediterreanMap;
    @Autowired
    @XStreamOmitField
    private DependentPropertyInitializer propertyInitializer;
    @PostConstruct
    private void initialisation() {
        try {
            propertyInitializer.initializeAnnotatedFields(this);
        } catch (IllegalAccessException e) {
            LOGGER.warn("Failed to initialize DependentValue annotated fields");
        }
    }
}
