package ch.sahits.game.openpatrician.model.city.guild;

import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;

import java.util.List;

/**
 * Model for the guild. The guild model provides information that
 * are related to a guild in a specific city. For common guild information
 * shared by all guilds, see the {@link GuildSettings}.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Nov 06, 2016
 * @see GuildSettings
 */
public interface IGuild {
    /**
     * Retrieve the city where the guild is located.
     * @return
     */
    ICity getCity();

    /**
     * Retrieve all members of the guild.
     * @return
     */
    List<IPlayer> getMembers();

    /**
     * A player joins the guild. The entrance fee is not deduced here.
     * @param player
     */
    void join(IPlayer player);

    /**
     * Retreve the all auctions.
     * @return
     */
    List<IAuction> getAuctions();

    /**
     * Once the auction has happened the value must be reset.
     * @param auction to be removed
     */
    void resetAuction(IAuction auction);
}
