package ch.sahits.game.openpatrician.model.city.guild;

import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.IWare;

import java.time.LocalDateTime;

/**
 * Interface describing a trade agreement.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Dec 04, 2016
 */
public interface ITradeAgreement {
    /**
     * Retrieve the partner city of the trade.
     * @return
     */
    IMediterreanCity getTradeLocation();

    /**
     * Retrieve the date till when the agreement is valid.
     * @return
     */
    LocalDateTime getValidTill();

    /**
     * Retreive the amount and the price which is guaranteed.
     * @return
     */
    AmountablePrice<IWare> getWareAndAmount();

    /**
     * Retrieve the ware for this trade agreement.
      * @return
     */
    IWare getWare();
}
