package ch.sahits.game.openpatrician.model.city.guild.impl;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.IBuilding;
import ch.sahits.game.openpatrician.model.city.guild.IBuildingAuction;
import lombok.Getter;

import java.time.LocalDateTime;

/**
 * Implement the auction for a building
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Nov 13, 2016
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.MODEL, EClassCategory.PROTOTYPE_BEAN})
public class BuildingAuction extends AbstractAuction implements IBuildingAuction {
    @Getter
    private final IBuilding auctionedBuilding;

    /**
     * Create an auction for a building.
     * @param auctionDate
     * @param startingBid
     * @param owner
     * @param auctionedBuilding
     */
    public BuildingAuction(LocalDateTime auctionDate, int startingBid, IPlayer owner, IBuilding auctionedBuilding) {
        super(auctionDate, startingBid, owner);
        this.auctionedBuilding = auctionedBuilding;
    }
}
