package ch.sahits.game.openpatrician.model.city.impl;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.product.IWare;
import lombok.Getter;

import java.time.LocalDateTime;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Aug 01, 2015
 */
@ClassCategory(EClassCategory.DEPENDS_ON_SERIALIZED_BEAN)
public class Contribution {
    @Getter
    private final LocalDateTime timestamp;
    @Getter
    private final int amount;
    @Getter
    private final IWare ware;

    public Contribution(LocalDateTime timestamp, int amount, IWare ware) {
        this.timestamp = timestamp;
        this.amount = amount;
        this.ware = ware;
    }
}
