package ch.sahits.game.openpatrician.model.city.impl;

import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.city.ILoanRequest;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.experimental.Builder;

import java.time.LocalDateTime;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 30, 2014
 */
@RequiredArgsConstructor
@Builder
@ClassCategory(EClassCategory.DEPENDS_ON_SERIALIZED_BEAN)
public class LoanRequest implements ILoanRequest {
    private final LocalDateTime issued;
    @Getter
    private final ICitizen citizen;
    @Getter
    private final int durationInWeeks;
    @Getter
    private final int sum;

    @Override
    public LocalDateTime issued() {
        return issued;
    }
}
