package ch.sahits.game.openpatrician.model.event;

import ch.sahits.game.event.data.PauseGame;
import ch.sahits.game.event.data.ResumeGame;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

/**
 *
 * Schedulable task that can be paused.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Jan 13, 2016
 */
public abstract class PausableSchedulableTask extends SchedulableTask {
    private boolean paused = false;
    @Autowired
    @Qualifier("timerEventBus")
    private AsyncEventBus timerEventBus;
    @PostConstruct
    protected void register() {
        timerEventBus.register(this);
    }
    @PreDestroy
    public void unregister() {
        timerEventBus.unregister(this);
    }
    @Subscribe
    public void pause(PauseGame evt) {
        paused = true;
    }
    @Subscribe
    public void resume (ResumeGame evt) {
        paused = false;
    }

    @Override
    public void run() {
        if (!paused) {
            super.run();
        }
    }
}
