package ch.sahits.game.openpatrician.model.people;

import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.IWare;

import java.time.LocalDateTime;

/**
 * A buyer promises to buy wares within a given time frame at a certain price.
 * The bought wares will not be sold to the city.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 27, 2013
 *
 */
public interface IBuyer extends ISideRoomPerson {
	/**
	 * Retrieve the buyers name.
	 * @return
	 */
	String getName();
	/**
	 * Date until which the wares have to be delivered.
	 * @return
	 */
	LocalDateTime getTimeFrame();
	/**
	 * Wares that are to be delivered.
	 * @return
	 */
	IWare getWare();
	/**
	 * Retrieve the amount and price of the ware.
	 * @return
	 */
	AmountablePrice<IWare> getAmountablePrice();

	void setName(String name);

	void setDeadline(LocalDateTime deadline);

	void setWare(IWare ware);

	void setAmountablePrice(AmountablePrice<IWare> amountablePrice);
}
