package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.people.ITradePerson;
import lombok.Getter;
import lombok.Setter;

/**
 * Base implementation of trading person
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 23, 2013
 *
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class BaseTradePerson implements ITradePerson {
    @Getter
    @Setter
	private IWare ware;
    @Getter
    @Setter
	private int amount;
    @Getter
    @Setter
	private int avgPricePerItem;


}