package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.model.AUpdatable;
import ch.sahits.game.openpatrician.model.people.IPirateHunter;
import lombok.Getter;
import lombok.Setter;

/**
 * Implementation of a pirate hunter. Every city can have a pirate hunter and is referenced
 * through it's TavernEngine.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 20, 2013
 *
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@AUpdatable
public class PirateHunterState extends BaseTavernPerson implements IPirateHunter {
    @Getter
    @Setter
	private String clientName;
    @Getter
    @Setter
	private String pirateName;
    @Getter
    @Setter
	private int premium;

}
