package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.model.people.ISailorState;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;

@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class SailorsState implements ISailorState {

	private final IntegerProperty nbSailors;
	private final BooleanProperty present;

    public SailorsState() {
        nbSailors = new SimpleIntegerProperty(this, "nbSailors", 0);
        present = new SimpleBooleanProperty(this, "present", false);
        present.bind(nbSailors.greaterThan(0));
    }

	@Override
	public int getNumberOfSailors() {
		return nbSailors.get();
	}
	@Override
	public void setNumberOfSailors(int number) {
		nbSailors.set(Math.max(number,0));
	}

	@Override
	public void hire() {
		if (getNumberOfSailors() > 0) {
			nbSailors.set(nbSailors.get()-1);
		}
	}
    @Override
    public IntegerProperty numberOfSailorsProperty() {
        return nbSailors;
    }

	@Override
	public void fire() {
		nbSailors.set(nbSailors.get() + 1);
	}
	@Override
	public boolean isPresent() {
		return present.get();
	}


}
