package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.model.AUpdatable;
import ch.sahits.game.openpatrician.model.people.IWarehouseTenant;
import lombok.Getter;
import lombok.Setter;

/**
 * Implementation of a warehouse tenant. Every city can have a warehouse tenant and is referenced
 * through it's TavernEngine.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 20, 2013
 *
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@AUpdatable
public class WarehouseTenant extends BaseTavernPerson implements
IWarehouseTenant {

    @Getter
    @Setter
    private String name;
    @Getter
    @Setter
    private int amount;


	@Override
	public int getRentPerWeek() {
		return 5*amount;
	}

}
