package ch.sahits.game.openpatrician.model.personal;

import ch.sahits.game.openpatrician.model.city.ICity;

import java.time.LocalDateTime;


/**
 * Defining the personal data of a person.
 * @author Andi Hotz, (c) Sahits GmbH, 2012
 * Created on Jul 23, 2012
 *
 */
public interface IPersonalData {
	/**
	 * Retrieve the players name
	 * @return
	 */
	String getName();
	/**
	 * Get a players last name
	 * @return
	 */
	String getLastName();
	/**
	 * Check if the player is male
	 * @return
	 */
	boolean isMale();
	/**
	 * Retrieve the birth place
	 * @return
	 */
	ICity getBirthPlace();
	/**
	 * Retrieve the birth date
	 * @return
	 */
	LocalDateTime getBirthDate();

	/**
	 * Compute the current age
	 * @param current date
	 * @return
	 */
	int getAge(LocalDateTime current);

}
