package ch.sahits.game.openpatrician.model.player;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.IShip;

/**
 * Strategy for upgrading the ship.
 * @author Andi Hotz, (c) Sahits GmbH, 2017
 * Created on Nov 04, 2017
 */
public interface IAIShipUpgradeStrategy {
    /**
     * Check if the ship should be upgraded.
     * @param ship
     * @return
     */
    boolean shouldUpgrade(IShip ship);

    /**
     * Upgrade the ship in city.
     * @param ship
     * @param city
     */
    void upgrade(IShip ship, ICity city);
}
