package ch.sahits.game.openpatrician.model.product;

import javafx.geometry.Point2D;

/**
 * Definition of the price curve as a bezier curve.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Aug 14, 2016
 */
public interface IBezierPriceCurve {
    /**
     * Get the start point for the bezier curve, where x == 0.
     * @return
     */
    Point2D getStart();

    /**
     * Get the end point for the bezier curve, where x == saturation
     * @return
     */
    Point2D getEnd();

    /**
     * Retrieve the first control point controlling the tangential leaving of the curve at the start.
     * @return
     */
    Point2D getControlPoint1();

    /**
     * Retrieve the second control point controlling the tangential entering into the end point.
     * @return
     */
    Point2D getControlPoint2();
}
