package ch.sahits.game.openpatrician.model.product;

import ch.sahits.game.openpatrician.model.city.ECityState;
import ch.sahits.game.openpatrician.model.city.IPopulationStructure;

/**
 * This interface defines the price calculation algorithm.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Aug 14, 2016
 */
public interface IPriceCalculationV2 {
    /**
     * Compute the price for one item of the ware. Though the price is only handled in further
     * computation as integer value, this method returns its value as double so this condition can be
     * tested:<br>
     * The higher the available amount (but still below the saturation value) the smaller (strictly) the returned
     * value.<br>
     * For different starting values:<br>
     * If  the starting value b is below starting point a the whole curve of b is below (not necessary strictly)
     * the curve of a. The curve is continues between 0 (inclusive) and infinity.
     * @param tradable defining all the parameters specific for the ware that is traded that is required for the calculation
     * @param buy flag indicating if the calculation should happen for buying or selling.
     * @param available amount of wares that are available in the market
     * @param productionRate amount the city can produce within a week
     * @param pop population structure that may have an influence on the calculated price
     * @param state state of the city
     * @return price for one item sold
     */
    int computePrice(ITradable tradable, boolean buy, int available, int productionRate, IPopulationStructure pop, ECityState state);
}
