package ch.sahits.game.openpatrician.model.server;

import ch.sahits.game.openpatrician.model.map.MapSegmentedImage;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

import java.time.LocalDateTime;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Dec 07, 2015
 */
@RequiredArgsConstructor
@Getter
@ClassCategory({EClassCategory.EVENT_OBJECT, EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
public class MapSegmentDataCheck {
    private final INavigableVessel ship;
    private final MapSegmentedImage mapSegment;
    private final LocalDateTime deadline;
}
