package ch.sahits.game.openpatrician.model.ship;

import ch.sahits.game.openpatrician.model.weapon.IWeapon;
import javafx.geometry.Point2D;

import java.util.Optional;

/**
 * One slot for a weapon
 * @author Andi Hotz, (c) Sahits GmbH, 2017
 * Created on Aug 15, 2017
 */
public interface IWeaponSlot {
    /**
     * Retrieve the side the slot is located on.
     * @return
     */
    ESide getSide();

    /**
     * Retrieve the weapon stored in this slot.
     * @return
     */
    Optional<IWeapon> getWeapon();

    /**
     * Set or unset a weapon in the slot. <code>null</code> will unset the weapon.
     * @param weapon
     */
    void setWeapon(IWeapon weapon);

    /**
     * Retrieve the offset of the empty weapon slot.
     * @return
     */
    Point2D getOffset();

    /**
     * Retrieve the identifier for this slot.
     * @return
     */
    int getId();
}
