package ch.sahits.game.openpatrician.model.weapon;

import javafx.beans.property.ReadOnlyIntegerProperty;

import java.time.LocalDateTime;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2017
 *         Created on Jul 23, 2017
 */
public interface IArmory {
    /**
     * Property holding the amount of swords in the storage.
     * @return
     */
    ReadOnlyIntegerProperty swordAmountProperty();
    /**
     * Property holding the amount of bows in the storage.
     * @return
     */
    ReadOnlyIntegerProperty bowAmountProperty();
    /**
     * Property holding the amount of crossbows in the storage.
     * @return
     */
    ReadOnlyIntegerProperty crossbowAmountProperty();
    /**
     * Property holding the amount of musket in the storage.
     * @return
     */
    ReadOnlyIntegerProperty musketAmountProperty();
    /**
     * Property holding the amount of hand weapons in the storage.
     * @return
     */
    ReadOnlyIntegerProperty cutlassAmountProperty();
    /**
     * Property holding the amount of small trebuchet in the storage.
     * @return
     */
    ReadOnlyIntegerProperty trebuchetSmallAmountProperty();
    /**
     * Property holding the amount of big trebuchet in the storage.
     * @return
     */
    ReadOnlyIntegerProperty trebuchetBigAmountProperty();
    /**
     * Property holding the amount of small ballista in the storage.
     * @return
     */
    ReadOnlyIntegerProperty ballistaSmallAmountProperty();
    /**
     * Property holding the amount of big ballista in the storage.
     * @return
     */
    ReadOnlyIntegerProperty ballistaBigAmountProperty();
    /**
     * Property holding the amount of bombard in the storage.
     * @return
     */
    ReadOnlyIntegerProperty bombardAmountProperty();
    /**
     * Property holding the amount of canon in the storage.
     * @return
     */
    ReadOnlyIntegerProperty canonAmountProperty();
    /**
     * Indicate that the sword should be produced with priority
     * @return
     */
    boolean isSwordPriority();
    /**
     * Indicate that the bow should be produced with priority
     * @return
     */

    boolean isBowPriority();
    /**
     * Indicate that the crossbow should be produced with priority
     * @return
     */

    boolean isCrossbowPriority();
    /**
     * Indicate that the musket should be produced with priority
     * @return
     */

    boolean isMusketPriority();
    /**
     * Toggle the priority of the sword.
     */
    void toggleSwordPriority();
    /**
     * Toggle the priority of the bow.
     */
    void toggleBowPriority();
    /**
     * Toggle the priority of the crossbow.
     */
    void toggleCrossbowPriority();
    /**
     * Toggle the priority of the musket.
     */
    void toggleMusketPriority();

    /**
     * Update the amount of swords by the <code>delta</code> amount
     * @param delta amount to be changed.
     */
    void updateSwordAmount(int delta);
    /**
     * Update the amount of bows by the <code>delta</code> amount
     * @param delta amount to be changed.
     */
    void updateBowAmount(int delta);
    /**
     * Update the amount of crossbows by the <code>delta</code> amount
     * @param delta amount to be changed.
     */
    void updateCrossbowAmount(int delta);
    /**
     * Update the amount of musket by the <code>delta</code> amount
     * @param delta amount to be changed.
     */
    void updateMusketAmount(int delta);
    /**
     * Update the amount of hand weapon by the <code>delta</code> amount
     * @param delta amount to be changed.
     */
    void updateCutlassAmount(int delta);
    /**
     * Update the amount of small trebuchet by the <code>delta</code> amount
     * @param delta amount to be changed.
     */
    void updateTrebuchetSmallAmount(int delta);
    /**
     * Update the amount of big trebuchet by the <code>delta</code> amount
     * @param delta amount to be changed.
     */
    void updateTrebuchetBigAmount(int delta);
    /**
     * Update the amount of small ballista by the <code>delta</code> amount
     * @param delta amount to be changed.
     */
    void updateBallistaSmallAmount(int delta);
    /**
     * Update the amount of big ballista by the <code>delta</code> amount
     * @param delta amount to be changed.
     */
    void updateBallistaBigAmount(int delta);
    /**
     * Update the amount of bombard by the <code>delta</code> amount
     * @param delta amount to be changed.
     */
    void updateBombardAmount(int delta);
    /**
     * Update the amount of canon by the <code>delta</code> amount
     * @param delta amount to be changed.
     */
    void updateCanonAmount(int delta);

    /**
     * Retrieve the experience of the blacksmith.
      * @return experience in [0,1]
     */
    double getExperience();

    /**
     * Increase the experience.
      */
    void gainExperience();

    /**
     * Date until the blacksmith has work.
      * @return
     */
    LocalDateTime occupiedUntil();

    /**
     * Date in the future until which the blacksmith has work.
      * @param date
     */
    void occupy(LocalDateTime date);
}
