/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.city.impl;

import ch.sahits.datastructure.GenericPair;
import ch.sahits.game.event.data.ClockTickPostDayChange;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.city.IBuildingProduction;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.IShipyard;
import ch.sahits.game.openpatrician.model.city.PopulationConsume;
import ch.sahits.game.openpatrician.model.city.impl.CityWall;
import ch.sahits.game.openpatrician.model.city.impl.ECityState;
import ch.sahits.game.openpatrician.model.city.impl.PopulationUpdateStats;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.MapType;
import ch.sahits.game.openpatrician.utilities.annotation.ObjectPropertyType;
import ch.sahits.game.openpatrician.utilities.spring.DependentPropertyInitializer;
import ch.sahits.game.openpatrician.utilities.spring.DependentValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.time.LocalDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class CityState {
    @XStreamOmitField
    private static final Logger LOGGER = LogManager.getLogger(CityState.class);
    @Autowired
    @XStreamOmitField
    private Random rnd;
    @DependentValue(value="ware.surplus.treshold")
    private double surplusThreshold;
    private ICity city;
    @MapType(key=IWare.class, value=Double.class)
    private Map<IWare, Double> consumed = new HashMap<IWare, Double>();
    private TavernState tavernState = null;
    private IShipyard shipyardState = null;
    @Autowired
    private PopulationConsume consume;
    @Autowired
    @XStreamOmitField
    private IBuildingProduction buildingProduction;
    @Autowired
    @XStreamOmitField
    private DependentPropertyInitializer propertyInitializer;
    @Autowired
    private CityWall cityWall;
    @Autowired
    private PopulationUpdateStats popUpdateStatistic;
    @Autowired
    @Qualifier(value="timerEventBus")
    @XStreamOmitField
    private AsyncEventBus timerEventBus;
    @Autowired
    private Date date;
    @MapType(key=IWare.class, value=LocalDateTime.class)
    private Map<IWare, LocalDateTime> longestMissingWares = new HashMap<IWare, LocalDateTime>();
    @ObjectPropertyType(value=IWare.class)
    private ObjectBinding<IWare> longestMissingWare = null;
    private BooleanBinding famine;
    @ObjectPropertyType(value=ECityState.class)
    private ObjectBinding<ECityState> cityEvent;
    @ObjectPropertyType(value=ECityState.class)
    private ObjectProperty<ECityState> cityState = new SimpleObjectProperty(null);

    public CityState(ICity city, IShipyard shipard, TavernState tavern) {
        this.city = city;
        this.shipyardState = shipard;
        this.tavernState = tavern;
    }

    @PostConstruct
    private void initCity() {
        EWare[] wares;
        for (EWare ware : wares = EWare.values()) {
            this.replaceConsumedAmount(ware, 0.0);
        }
        if (this.city.getCityState() == null) {
            this.city.setCityState(this);
        }
        try {
            this.propertyInitializer.initializeAnnotatedFields((Object)this);
        }
        catch (IllegalAccessException e) {
            LOGGER.warn("Failed to initialize DependentValue annotated fields");
        }
        this.longestMissingWaresBinding();
        this.dailyUpdate(null);
        this.timerEventBus.register((Object)this);
    }

    @Subscribe
    public void dailyUpdate(ClockTickPostDayChange dayChange) {
        ArrayList<EWare> wares = new ArrayList<EWare>(Arrays.asList(EWare.values()));
        Collections.shuffle(wares);
        LocalDateTime now = this.date.getCurrentDate();
        boolean changed = false;
        for (IWare iWare : wares) {
            if (this.city.getWare(iWare).getAmount() <= 0) {
                if (this.longestMissingWares.containsKey(iWare)) continue;
                this.longestMissingWares.put(iWare, now);
                changed = true;
                continue;
            }
            if (this.longestMissingWares.remove(iWare) == null) continue;
            changed = true;
        }
        if (changed && this.longestMissingWare != null) {
            this.longestMissingWare.invalidate();
        }
    }

    private IWare getLongestMissingWares() {
        GenericPair oldest = new GenericPair(null, (Object)this.date.getCurrentDate());
        for (Map.Entry<IWare, LocalDateTime> entry : this.longestMissingWares.entrySet()) {
            if (!entry.getValue().isBefore((ChronoLocalDateTime)oldest.getSecond())) continue;
            oldest = new GenericPair((Object)entry.getKey(), (Object)entry.getValue());
        }
        return (IWare)oldest.getFirst();
    }

    public ObjectBinding<IWare> longestMissingWaresBinding() {
        if (this.longestMissingWare == null) {
            this.longestMissingWare = new ObjectBinding<IWare>(){

                protected IWare computeValue() {
                    return CityState.this.getLongestMissingWares();
                }
            };
        }
        return this.longestMissingWare;
    }

    private boolean isFamine() {
        LocalDateTime twoWeeksAgo = this.date.getCurrentDate().minusWeeks(2L);
        if (this.longestMissingWares.containsKey(EWare.GRAIN)) {
            return this.longestMissingWares.get(EWare.GRAIN).isBefore(twoWeeksAgo);
        }
        return false;
    }

    public BooleanBinding famineBinding() {
        if (this.famine == null) {
            this.famine = new BooleanBinding(){

                protected boolean computeValue() {
                    return CityState.this.isFamine();
                }
            };
        }
        return this.famine;
    }

    public ObjectProperty<ECityState> cityEventProperty() {
        return this.cityState;
    }

    public Set<Map.Entry<IWare, Double>> consumedEntries() {
        return this.consumed.entrySet();
    }

    public void replaceConsumedAmount(IWare ware, double amount) {
        this.consumed.put(ware, amount);
    }

    public double getConsumedAmount(EWare ware) {
        return this.consumed.get(ware);
    }

    public Optional<IWare> findMostNeededWare() {
        Map<IWare, LocalDateTime> missing = this.city.getMissingWares();
        LocalDateTime earliest = null;
        IWare result = null;
        for (Map.Entry<IWare, LocalDateTime> entry : missing.entrySet()) {
            if (earliest != null && !entry.getValue().isBefore(earliest)) continue;
            earliest = entry.getValue();
            result = entry.getKey();
        }
        if (result == null) {
            Map<IWare, Integer> available = this.getSortedWareAvailabilityMap();
            IWare wareRunninOutFirst = null;
            int runsOutInDays = Integer.MAX_VALUE;
            for (Map.Entry<IWare, Integer> entry : available.entrySet()) {
                int days;
                IWare ware = entry.getKey();
                double consumptionPerWeek = this.consume.getWeeklyConsumption(ware, this.city);
                double productionPerWeek = this.buildingProduction.getTotalProduction(ware, this.getCity());
                double dailyConsumtion = (productionPerWeek - consumptionPerWeek) / 7.0;
                if (dailyConsumtion >= 0.0 || (days = -((int)((double)entry.getValue().intValue() / dailyConsumtion))) >= runsOutInDays) continue;
                runsOutInDays = days;
                wareRunninOutFirst = ware;
            }
            result = wareRunninOutFirst;
        }
        return Optional.ofNullable(result);
    }

    public Optional<IWare> findWareWithMostSurplus() {
        ArrayList<EWare> surplus = new ArrayList<EWare>();
        for (EWare ware : EWare.values()) {
            AmountablePrice<IWare> amount = this.city.getWare(ware);
            double actualPrice = amount.getAVGPrice();
            int minPrice = ware.getMinValueSell();
            double val = (double)minPrice / actualPrice - 1.0;
            if (!(val <= this.surplusThreshold)) continue;
            surplus.add(ware);
        }
        if (surplus.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(surplus.get(this.rnd.nextInt(surplus.size())));
    }

    @VisibleForTesting
    Map<IWare, Integer> getSortedWareAvailabilityMap() {
        Comparator<IWare> comparator = new Comparator<IWare>(){

            @Override
            public int compare(IWare ware1, IWare ware2) {
                return CityState.this.city.getWare(ware1).getAmount() - CityState.this.city.getWare(ware2).getAmount();
            }
        };
        TreeMap<IWare, Integer> map = new TreeMap<IWare, Integer>(comparator);
        for (EWare ware : EWare.values()) {
            map.put(ware, this.city.getWare(ware).getAmount());
        }
        map.size();
        return map;
    }

    public ICity getCity() {
        return this.city;
    }

    public TavernState getTavernState() {
        return this.tavernState;
    }

    public IShipyard getShipyardState() {
        return this.shipyardState;
    }

    public CityWall getCityWall() {
        return this.cityWall;
    }

    public void setCityWall(CityWall cityWall) {
        this.cityWall = cityWall;
    }

    public PopulationUpdateStats getPopUpdateStatistic() {
        return this.popUpdateStatistic;
    }
}

