/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.event;

import ch.sahits.game.event.data.ClockTick;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.SetType;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.Iterator;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.SINGLETON_BEAN})
public class TimedUpdatableTaskList {
    @Autowired
    private Date date;
    @Autowired
    @Qualifier(value="timerEventBus")
    @XStreamOmitField
    private AsyncEventBus timerEventBus;
    @SetType(value=TimedTask.class)
    private final ConcurrentSkipListSet<TimedTask> sortedEvents;

    @PostConstruct
    public void registerWithClock() {
        this.timerEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregister() {
        this.timerEventBus.unregister((Object)this);
    }

    public TimedUpdatableTaskList() {
        Comparator<TimedTask> comparator = new Comparator<TimedTask>(){

            @Override
            public int compare(TimedTask task1, TimedTask task2) {
                return task1.getExecutionTime().compareTo(task2.getExecutionTime());
            }
        };
        this.sortedEvents = new ConcurrentSkipListSet<TimedTask>(comparator);
    }

    public void add(TimedTask task) {
        this.sortedEvents.add(task);
    }

    public void remove(TimedTask task) {
        this.sortedEvents.remove(task);
    }

    @Subscribe
    public void handleClockTick(ClockTick event) {
        LocalDateTime now = this.date.getCurrentDate();
        Iterator<TimedTask> iterator = this.sortedEvents.iterator();
        while (iterator.hasNext()) {
            TimedTask task = iterator.next();
            Preconditions.checkNotNull((Object)task.getExecutionTime(), (Object)"The exectution time of the task may not be null");
            if (task.getExecutionTime().isBefore(now)) {
                task.run();
                iterator.remove();
            }
            if (!task.getExecutionTime().isAfter(now)) continue;
            break;
        }
    }

    TimedTask getFirst() {
        return this.sortedEvents.first();
    }
}

