/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.impl;

import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.Difficulty;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.EGameSpeed;
import ch.sahits.game.openpatrician.model.EObjective;
import ch.sahits.game.openpatrician.model.IGame;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ObjectPropertyType;
import ch.sahits.game.openpatrician.utilities.annotation.UniquePrototype;
import ch.sahits.game.openpatrician.utilities.model.IGameType;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.xml.bind.annotation.XmlElement;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@UniquePrototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.SINGLETON_BEAN})
public class Game
implements IGame,
IGameType {
    @Autowired
    private IMap map;
    private final EObjective objective;
    private final Difficulty difficulty;
    @ObjectPropertyType(value=EGameSpeed.class)
    private ObjectProperty<EGameSpeed> gameSpeed;
    private boolean fastforward = false;
    @Autowired
    private Date time;
    private boolean singleplayer;
    @Autowired
    @Qualifier(value="clientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientEventBus;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientServerEventBus;
    @XmlElement
    private static boolean constructed = false;

    public Game(EObjective objective, Difficulty difficulty, EGameSpeed speed, boolean singleplayer) {
        Preconditions.checkState((!constructed ? 1 : 0) != 0, (Object)"The game may only be instantiated once.");
        this.objective = objective;
        this.difficulty = difficulty;
        this.gameSpeed = new SimpleObjectProperty((Object)speed);
        this.singleplayer = singleplayer;
        constructed = true;
    }

    @PostConstruct
    private void init() {
        this.clientEventBus.register((Object)this);
        this.clientServerEventBus.register((Object)this);
        this.setupGamespeed();
    }

    private void setupGamespeed() {
        switch ((EGameSpeed)((Object)this.gameSpeed.get())) {
            case BREAK: {
                this.time.setTickUpdate(0);
                break;
            }
            case SLOW: {
                this.time.setTickUpdate(5);
                break;
            }
            case MEDIUM: {
                this.time.setTickUpdate(30);
                break;
            }
            case FAST: {
                this.time.setTickUpdate(60);
            }
        }
    }

    @PreDestroy
    private void unregister() {
        this.clientEventBus.unregister((Object)this);
        this.clientServerEventBus.unregister((Object)this);
    }

    @Override
    public void setGameSpeed(EGameSpeed speed) {
        this.gameSpeed.setValue((Object)speed);
        this.setupGamespeed();
    }

    @Subscribe
    public void handleMessage(DisplayMessage message) {
        this.normalSpeed();
    }

    @Override
    public void normalSpeed() {
        if (this.fastforward) {
            this.init();
            this.fastforward = false;
            System.out.println("Fall back to normal speed: " + this.gameSpeed);
        }
    }

    @Override
    public void fastForward() {
        if (this.gameSpeed.get() != EGameSpeed.FAST) {
            if (this.fastforward) {
                this.normalSpeed();
            } else {
                this.time.setTickUpdate(60);
                this.fastforward = true;
                System.out.println("Move to fast forward");
            }
        }
    }

    @Override
    public boolean isObjectivReached() {
        return false;
    }

    public boolean isSinglePlayer() {
        return this.singleplayer;
    }

    @Override
    public EGameSpeed getGameSpeed() {
        return (EGameSpeed)((Object)this.gameSpeed.get());
    }

    @Override
    public ObjectProperty<EGameSpeed> gameSpeedProperty() {
        return this.gameSpeed;
    }

    @Override
    public IMap getMap() {
        return this.map;
    }

    @Override
    public Difficulty getDifficulty() {
        return this.difficulty;
    }

    @Override
    public Date getTime() {
        return this.time;
    }
}

