/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.initialisation.StartNewGameBean;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.model.people.ICaptain;
import ch.sahits.game.openpatrician.model.people.impl.CaptainTownMapping;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import com.google.common.collect.Lists;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.SINGLETON_BEAN})
public class CaptainsState {
    @Autowired
    @XStreamOmitField
    private Random rnd;
    @Value(value="${tavern.captain.presence.max}")
    private int maxDaysPresent;
    @Autowired
    private IMap map;
    @Autowired
    private Date date;
    @ListType(value=CaptainTownMapping.class)
    private List<CaptainTownMapping> captainMapping = Lists.newArrayList();
    @ListType(value=ICaptain.class)
    private List<ICaptain> captains = Lists.newArrayList();

    public void addCaptain(ICity city, LocalDateTime arrival, ICaptain captain) {
        this.assignCaptainToCity(captain, city, arrival);
        this.captains.add(captain);
    }

    private ICity getRandomCity() {
        List<ICity> cities = this.map.getCities();
        return cities.get(this.rnd.nextInt(cities.size()));
    }

    public void assignCaptainToCity(ICaptain captain, ICity city, LocalDateTime arrivalDate) {
        this.captainMapping.add(new CaptainTownMapping(city, arrivalDate, captain));
    }

    public Optional<ICaptain> getCaptain(ICity city) {
        for (CaptainTownMapping mapped : this.captainMapping) {
            if (!mapped.getTown().equals(city)) continue;
            return Optional.of(mapped.getCaptain());
        }
        return Optional.empty();
    }

    public LocalDateTime getArrivalDate(ICaptain captain) {
        for (CaptainTownMapping mapping : this.captainMapping) {
            if (!mapping.getCaptain().equals(captain)) continue;
            return mapping.getArrivalDate();
        }
        throw new IllegalStateException("The captain is not present in any town");
    }

    public void hireCaptain(ICaptain captain, ICity city) {
        Iterator<CaptainTownMapping> iterator = this.captainMapping.iterator();
        while (iterator.hasNext()) {
            CaptainTownMapping mapped = iterator.next();
            if (!mapped.getTown().equals(city) || !mapped.getCaptain().equals(captain)) continue;
            iterator.remove();
            break;
        }
    }

    public List<ICaptain> getAllFreeCaptains() {
        ArrayList<ICaptain> freeCaptains = new ArrayList<ICaptain>();
        for (ICaptain captain : this.captains) {
            if (captain.getAssignedShip().isPresent()) continue;
            freeCaptains.add(captain);
        }
        return freeCaptains;
    }

    public Optional<ICity> findCaptainsCurrentCity(ICaptain captain) {
        for (CaptainTownMapping mapping : this.captainMapping) {
            if (!mapping.getCaptain().equals(captain)) continue;
            return Optional.of(mapping.getTown());
        }
        return Optional.empty();
    }

    public int getMaxDaysPresent() {
        return this.maxDaysPresent;
    }
}

