/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.people.INonFreeSeaPirate;
import ch.sahits.game.openpatrician.model.people.impl.SeaPirate;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.OptionalType;
import java.time.LocalDateTime;
import java.util.Optional;

@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class NonFreeSeaPirate
extends SeaPirate
implements INonFreeSeaPirate {
    @OptionalType(value=ICity.class)
    private final Optional<ICity> nearCity;
    private final IPlayer hiringPlayer;
    private final LocalDateTime hireDate;

    public NonFreeSeaPirate(IPlayer hiringPlayer, LocalDateTime hireDate, ICity nearCity) {
        this.nearCity = Optional.ofNullable(nearCity);
        this.hiringPlayer = hiringPlayer;
        this.hireDate = hireDate;
    }

    @Override
    public Optional<ICity> roamingNearCity() {
        return this.nearCity;
    }

    @Override
    public IPlayer getHiringPlayer() {
        return this.hiringPlayer;
    }

    @Override
    public LocalDateTime getHireDate() {
        return this.hireDate;
    }
}

