/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.personal.impl;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.personal.ISpouseData;
import ch.sahits.game.openpatrician.model.personal.impl.PersonalData;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import java.time.LocalDateTime;

@ClassCategory(value={EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
public class SpouseData
extends PersonalData
implements ISpouseData {
    private final int popularityInHerHomeTown;
    private final int popularityInYourHomeTown;
    private final int connectionsInHerHomeTown;
    private final int connectionsInYourHomeTown;
    private final String portraitResourceName;

    public SpouseData(String name, String lastName, boolean male, ICity birthplace, LocalDateTime birthDate, int popHer, int popYour, int conHer, int conYour, String portraitResourceName) {
        super(name, lastName, male, birthplace, birthDate);
        this.popularityInHerHomeTown = popHer;
        this.popularityInYourHomeTown = popYour;
        this.connectionsInHerHomeTown = conHer;
        this.connectionsInYourHomeTown = conYour;
        this.portraitResourceName = portraitResourceName;
    }

    public static SpouseDataBuilder builder() {
        return new SpouseDataBuilder();
    }

    @Override
    public int getPopularityInHerHomeTown() {
        return this.popularityInHerHomeTown;
    }

    @Override
    public int getPopularityInYourHomeTown() {
        return this.popularityInYourHomeTown;
    }

    @Override
    public int getConnectionsInHerHomeTown() {
        return this.connectionsInHerHomeTown;
    }

    @Override
    public int getConnectionsInYourHomeTown() {
        return this.connectionsInYourHomeTown;
    }

    @Override
    public String getPortraitResourceName() {
        return this.portraitResourceName;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpouseData)) {
            return false;
        }
        SpouseData other = (SpouseData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPopularityInHerHomeTown() != other.getPopularityInHerHomeTown()) {
            return false;
        }
        if (this.getPopularityInYourHomeTown() != other.getPopularityInYourHomeTown()) {
            return false;
        }
        if (this.getConnectionsInHerHomeTown() != other.getConnectionsInHerHomeTown()) {
            return false;
        }
        if (this.getConnectionsInYourHomeTown() != other.getConnectionsInYourHomeTown()) {
            return false;
        }
        String this$portraitResourceName = this.getPortraitResourceName();
        String other$portraitResourceName = other.getPortraitResourceName();
        return !(this$portraitResourceName == null ? other$portraitResourceName != null : !this$portraitResourceName.equals(other$portraitResourceName));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SpouseData;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPopularityInHerHomeTown();
        result = result * 59 + this.getPopularityInYourHomeTown();
        result = result * 59 + this.getConnectionsInHerHomeTown();
        result = result * 59 + this.getConnectionsInYourHomeTown();
        String $portraitResourceName = this.getPortraitResourceName();
        result = result * 59 + ($portraitResourceName == null ? 43 : $portraitResourceName.hashCode());
        return result;
    }

    public static class SpouseDataBuilder {
        private String name;
        private String lastName;
        private boolean male;
        private ICity birthplace;
        private LocalDateTime birthDate;
        private int popHer;
        private int popYour;
        private int conHer;
        private int conYour;
        private String portraitResourceName;

        SpouseDataBuilder() {
        }

        public SpouseDataBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SpouseDataBuilder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public SpouseDataBuilder male(boolean male) {
            this.male = male;
            return this;
        }

        public SpouseDataBuilder birthplace(ICity birthplace) {
            this.birthplace = birthplace;
            return this;
        }

        public SpouseDataBuilder birthDate(LocalDateTime birthDate) {
            this.birthDate = birthDate;
            return this;
        }

        public SpouseDataBuilder popHer(int popHer) {
            this.popHer = popHer;
            return this;
        }

        public SpouseDataBuilder popYour(int popYour) {
            this.popYour = popYour;
            return this;
        }

        public SpouseDataBuilder conHer(int conHer) {
            this.conHer = conHer;
            return this;
        }

        public SpouseDataBuilder conYour(int conYour) {
            this.conYour = conYour;
            return this;
        }

        public SpouseDataBuilder portraitResourceName(String portraitResourceName) {
            this.portraitResourceName = portraitResourceName;
            return this;
        }

        public SpouseData build() {
            return new SpouseData(this.name, this.lastName, this.male, this.birthplace, this.birthDate, this.popHer, this.popYour, this.conHer, this.conYour, this.portraitResourceName);
        }

        public String toString() {
            return "SpouseData.SpouseDataBuilder(name=" + this.name + ", lastName=" + this.lastName + ", male=" + this.male + ", birthplace=" + this.birthplace + ", birthDate=" + this.birthDate + ", popHer=" + this.popHer + ", popYour=" + this.popYour + ", conHer=" + this.conHer + ", conYour=" + this.conYour + ", portraitResourceName=" + this.portraitResourceName + ")";
        }
    }
}

