/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.player;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.player.BaseStrategyType;
import ch.sahits.game.openpatrician.model.player.ITradeStategyHint;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import ch.sahits.game.openpatrician.utilities.annotation.MultimapType;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;

@Prototype
@ClassCategory(value={EClassCategory.PROTOTYPE_BEAN, EClassCategory.SERIALIZABLE_BEAN})
public class AIPlayerContext {
    @MultimapType(key=ICity.class, value=ITradeStategyHint.class)
    private Multimap<ICity, ITradeStategyHint> hints = ArrayListMultimap.create();
    @ListType(value=BaseStrategyType.class)
    private List<BaseStrategyType<?>> generalStrategyTypes = new ArrayList();

    public void add(ICity city, ITradeStategyHint hint) {
        this.hints.put((Object)city, (Object)hint);
    }

    public List<ITradeStategyHint> getHints(ICity city) {
        return new ArrayList<ITradeStategyHint>(this.hints.get((Object)city));
    }

    public List<BaseStrategyType<?>> getGeneralStrategyTypes() {
        return new ArrayList(this.generalStrategyTypes);
    }

    public void add(BaseStrategyType<?> strategyType) {
        this.generalStrategyTypes.add(strategyType);
    }
}

