/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.product;

import ch.sahits.game.openpatrician.model.city.ECityState;
import ch.sahits.game.openpatrician.model.city.IPopulationStructure;
import ch.sahits.game.openpatrician.model.product.BasePriceCalulation;
import ch.sahits.game.openpatrician.model.product.IBezierPriceCurve;
import ch.sahits.game.openpatrician.model.product.ITradable;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.MultimapType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Point2D;

@ClassCategory(value={EClassCategory.HANDLER, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class BezierPriceCalculation
extends BasePriceCalulation {
    @MultimapType(key=ITradable.class, value=Point2D.class)
    private Multimap<ITradable, Point2D> cacheBuy = ArrayListMultimap.create();
    @MultimapType(key=ITradable.class, value=Point2D.class)
    private Multimap<ITradable, Point2D> cacheSell = ArrayListMultimap.create();

    public Point2D caclulateBezierPoint(double t, Point2D start, Point2D cp1, Point2D cp2, Point2D end) {
        double u = 1.0 - t;
        double tSquare = t * t;
        double tQube = t * t * t;
        double uSquare = u * u;
        double uQube = u * u * u;
        Point2D summand1 = start.multiply(uQube);
        Point2D summand2 = cp1.multiply(3.0 * uSquare * t);
        Point2D summand3 = cp2.multiply(3.0 * u * tSquare);
        Point2D summand4 = end.multiply(tQube);
        return summand1.add(summand2).add(summand3).add(summand4);
    }

    public List<Point2D> calculateDiscreteBezierPoints(Point2D start, Point2D cp1, Point2D cp2, Point2D end) {
        Preconditions.checkArgument((end.getX() > start.getX() ? 1 : 0) != 0, (Object)"The x coordinate of the end point must be larger than the one of the start point");
        int nbPoints = (int)Math.rint(end.getX() - start.getX());
        double delta = 0.015 / (double)nbPoints;
        double epsilon = 0.1;
        ArrayList<Point2D> points = new ArrayList<Point2D>(nbPoints);
        double lastX = start.getX() - 1.0;
        for (double t = 0.0; t <= 1.0; t += delta) {
            double descreteX;
            Point2D nextPoint = this.caclulateBezierPoint(t, start, cp1, cp2, end);
            if (!(nextPoint.getX() > lastX + 0.5) || !(Math.abs((descreteX = (double)((int)Math.rint(nextPoint.getX()))) - nextPoint.getX()) < epsilon)) continue;
            lastX = nextPoint.getX();
            Point2D p = new Point2D(Math.rint(nextPoint.getX()), Math.rint(nextPoint.getY()));
            points.add(p);
        }
        if (points.size() == nbPoints) {
            points.add(end);
        }
        return points;
    }

    @Override
    public int computePrice(ITradable tradable, boolean buy, int available, int productionRate, IPopulationStructure pop, ECityState state) {
        int min = this.getMinValue(tradable, buy);
        int max = this.getMaxValue(tradable, buy);
        int saturation = this.getSaturation(tradable, buy);
        if (available == 0) {
            return max;
        }
        if (available >= saturation) {
            return min;
        }
        if (buy) {
            if (!this.cacheBuy.containsKey((Object)tradable)) {
                IBezierPriceCurve curve = tradable.getBuyCurve();
                List<Point2D> points = this.calculateDiscreteBezierPoints(curve.getStart(), curve.getControlPoint1(), curve.getControlPoint2(), curve.getEnd());
                this.cacheBuy.putAll((Object)tradable, points);
            }
        } else if (!this.cacheSell.containsKey((Object)tradable)) {
            IBezierPriceCurve curve = tradable.getSellCurve();
            List<Point2D> points = this.calculateDiscreteBezierPoints(curve.getStart(), curve.getControlPoint1(), curve.getControlPoint2(), curve.getEnd());
            this.cacheSell.putAll((Object)tradable, points);
        }
        return this.getPrice(buy, tradable, available);
    }

    private int getPrice(boolean buy, ITradable tradable, int available) {
        Point2D firstGuess;
        ArrayList points = buy ? new ArrayList(this.cacheBuy.get((Object)tradable)) : new ArrayList(this.cacheSell.get((Object)tradable));
        int index = points.size() - 1;
        if (available >= 0) {
            index = Math.min(available, points.size() - 1);
        }
        if ((int)(firstGuess = (Point2D)points.get(index)).getX() == index) {
            return (int)firstGuess.getY();
        }
        if (firstGuess.getX() > (double)index) {
            for (int i = index - 1; i >= 0; --i) {
                Point2D p = (Point2D)points.get(i);
                if ((int)p.getX() != index) continue;
                return (int)p.getY();
            }
        } else {
            for (int i = index + 1; i < points.size(); ++i) {
                Point2D p = (Point2D)points.get(i);
                if ((int)p.getX() != index) continue;
                return (int)p.getY();
            }
        }
        return -1;
    }
}

