/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.ship;

import ch.sahits.game.openpatrician.model.ship.ESide;
import ch.sahits.game.openpatrician.model.ship.IWeaponSlot;
import ch.sahits.game.openpatrician.model.ship.PrimaryLargeWeaponSlot;
import ch.sahits.game.openpatrician.model.weapon.EWeapon;
import ch.sahits.game.openpatrician.model.weapon.IWeapon;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.OptionalType;
import java.beans.ConstructorProperties;
import java.util.Optional;
import javafx.geometry.Point2D;

@ClassCategory(value={EClassCategory.MODEL})
public class SecondaryLargeWeaponSlot
implements IWeaponSlot {
    private final ESide side;
    private final int id;
    @OptionalType(value=IWeapon.class)
    private Optional<IWeapon> weapon = Optional.empty();
    private Point2D offset;

    public void combineWithBigSlot(PrimaryLargeWeaponSlot primarySlot) {
        this.weapon = primarySlot.getWeapon();
    }

    @Override
    public void setWeapon(IWeapon weapon) {
        if (weapon == null) {
            this.weapon = Optional.empty();
        } else {
            this.assertWeaponType(weapon);
            this.weapon = Optional.of(weapon);
        }
    }

    private void assertWeaponType(IWeapon weapon) {
        if (weapon instanceof EWeapon) {
            EWeapon w = (EWeapon)weapon;
            if (w != EWeapon.TREBUCHET_SMALL && w != EWeapon.BALLISTA_SMALL && w != EWeapon.CANNON) {
                throw new IllegalArgumentException("The 'weapon' is not small");
            }
        } else {
            throw new IllegalArgumentException("'weapon' must be of type EWeapon");
        }
    }

    @Override
    public ESide getSide() {
        return this.side;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public Optional<IWeapon> getWeapon() {
        return this.weapon;
    }

    @Override
    public Point2D getOffset() {
        return this.offset;
    }

    @ConstructorProperties(value={"side", "id"})
    public SecondaryLargeWeaponSlot(ESide side, int id) {
        this.side = side;
        this.id = id;
    }

    public void setOffset(Point2D offset) {
        this.offset = offset;
    }
}

