/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.ship.impl;

import ch.sahits.game.openpatrician.model.AmountableProvider;
import ch.sahits.game.openpatrician.model.javafx.bindings.LateIntegerBinding;
import ch.sahits.game.openpatrician.model.people.ICaptain;
import ch.sahits.game.openpatrician.model.people.IShipOwner;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.ICog;
import ch.sahits.game.openpatrician.model.ship.ICrayer;
import ch.sahits.game.openpatrician.model.ship.IHolk;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ship.IShipGroup;
import ch.sahits.game.openpatrician.model.ship.ISnaikka;
import ch.sahits.game.openpatrician.model.weapon.IWeapon;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import javafx.beans.Observable;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.geometry.Point2D;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class ShipGroup
implements IShipGroup {
    @Autowired
    @XStreamOmitField
    private Random rnd;
    private BooleanProperty pirateFlag = new SimpleBooleanProperty(false);
    @ListType(value=IShip.class)
    private List<IShip> ships = new ArrayList<IShip>();
    @Autowired
    @XStreamOmitField
    private AmountableProvider amountableProvider;
    @XStreamOmitField
    private LateIntegerBinding loadBinding = null;

    public ShipGroup(IShip leadShip) {
        this.ships.add(leadShip);
    }

    @Override
    public int getSize() {
        return this.ships.stream().mapToInt(ship -> ship.getSize()).sum();
    }

    @Override
    public int getCapacity() {
        return this.ships.stream().mapToInt(ship -> ship.getCapacity()).sum();
    }

    @Override
    public String getName() {
        return this.ships.isEmpty() ? "" : this.ships.get(0).getName();
    }

    @Override
    public Set<IWare> getLoadedWares() {
        HashSet<IWare> loadedWares = new HashSet<IWare>();
        for (IShip ship : this.ships) {
            loadedWares.addAll(ship.getLoadedWares());
        }
        return loadedWares;
    }

    @Override
    public int load(IWare ware, int amount, int avgPrice) {
        int loadedAmount = 0;
        int remainingAmount = amount;
        for (IShip ship : this.ships) {
            if (ship.getCapacity() > 0 && (remainingAmount = amount - (loadedAmount += ship.load(ware, remainingAmount, avgPrice))) <= 0) break;
        }
        return loadedAmount;
    }

    @Override
    public int unload(IWare ware, int amount) {
        IShip ship;
        int unloadedAmount = 0;
        int remainingAmount = amount;
        Iterator<IShip> iterator = this.ships.iterator();
        while (iterator.hasNext() && (remainingAmount = amount - (unloadedAmount += (ship = iterator.next()).unload(ware, remainingAmount))) > 0) {
        }
        return unloadedAmount;
    }

    @Override
    public int getDamage() {
        return this.ships.stream().mapToInt(ship -> ship.getDamage()).max().getAsInt();
    }

    @Override
    public void damage(int damage, boolean destroyWeapon) {
        for (IShip ship : this.ships) {
            double rndFactor = Math.max(this.rnd.nextGaussian() + 1.0, 0.0);
            double typeFactor = 1.0;
            if (ship instanceof IHolk) {
                typeFactor = 0.75;
            }
            if (ship instanceof ICog) {
                typeFactor = 1.0;
            }
            if (ship instanceof ICrayer) {
                typeFactor = 1.3;
            }
            if (ship instanceof ISnaikka) {
                typeFactor = 1.7;
            }
            int actualDamage = (int)Math.round((double)damage * rndFactor * typeFactor);
            ship.damage(actualDamage, destroyWeapon);
        }
    }

    private LateIntegerBinding loadbinding() {
        if (this.loadBinding == null) {
            this.loadBinding = this.createLoadBinding();
        }
        return this.loadBinding;
    }

    private LateIntegerBinding createLoadBinding() {
        return new LateIntegerBinding(){
            {
                for (IShip ship : ShipGroup.this.ships) {
                    super.bind((Observable)ship.getLoadBinding());
                }
            }

            protected int computeValue() {
                return ShipGroup.this.ships.stream().mapToInt(ship -> ship.getLoadBinding().get()).sum();
            }
        };
    }

    @Override
    public IntegerBinding getLoadBinding() {
        return this.loadbinding();
    }

    @Override
    public AmountablePrice<IWare> getWare(IWare ware) {
        AmountablePrice<IWare> loadedWare = this.amountableProvider.createWareAmountable();
        for (IShip ship : this.ships) {
            AmountablePrice<IWare> amountable = ship.getWare(ware);
            loadedWare.add(amountable.getAmount(), amountable.getAVGPrice());
        }
        return loadedWare;
    }

    @Override
    public int getNumberOfSailors() {
        return this.ships.stream().mapToInt(ship -> ship.getNumberOfSailors()).sum();
    }

    @Override
    public Optional<ICaptain> getCaptian() {
        return Optional.empty();
    }

    @Override
    public Point2D getLocation() {
        return this.ships.get(0).getLocation();
    }

    @Override
    public void setLocation(Point2D location) {
        for (IShip ship : this.ships) {
            ship.setLocation(location);
        }
    }

    @Override
    public IShipOwner getOwner() {
        return this.ships.get(0).getOwner();
    }

    @Override
    public int getWeaponAmount(IWeapon weaponType) {
        return this.ships.stream().mapToInt(ship -> ship.getWeaponAmount(weaponType)).sum();
    }

    @Override
    public int getLoadableSpace() {
        return this.ships.stream().mapToInt(ship -> ship.getLoadableSpace()).sum();
    }

    @Override
    public double getTopSpeed() {
        return this.ships.stream().mapToDouble(ship -> ship.getTopSpeed()).max().getAsDouble();
    }

    @Override
    public double getCurrentSpeed() {
        return this.ships.stream().mapToDouble(ship -> ship.getCurrentSpeed()).min().getAsDouble();
    }

    @Override
    public String getUuid() {
        return this.ships.get(0).getUuid();
    }

    @Override
    public boolean getPirateFlag() {
        return this.pirateFlag.get();
    }

    @Override
    public void togglePirateFlag() {
        this.pirateFlag.setValue(Boolean.valueOf(this.pirateFlag.get()));
    }

    @Override
    public BooleanProperty pirateFlagProperty() {
        return this.pirateFlag;
    }

    @Override
    public List<IShip> getShips() {
        return new ArrayList<IShip>(this.ships);
    }

    @Override
    public void addShip(IShip ship) {
        this.ships.add(ship);
    }

    @Override
    public void removeShip(IShip ship) {
        this.ships.remove(ship);
    }
}

